var needEnterFullscreenButton = $$need_enter_fullscreen_button$$;
var needPreClick = $$need_pre_click$$;
var enablePlayCheck = $$enable_play_check$$;

function wvt_log(s) { console.log("[WebViewTV] " + s); }

function wvt_error(s) { console.error("[WebViewTV] " + s); }

function wvt_notifyVideoPlaying() {
	if (enablePlayCheck) {
		window.main.notifyVideoPlaying();
	}
}

function wvt_enablePlayCheck() {
	if (enablePlayCheck) {
		window.main.enablePlayCheck();
	}
}

function wvt_disablePlayCheck() {
	if (enablePlayCheck) {
		window.main.disablePlayCheck();
	}
}

function wvt_onTimeUpdate(video) {
	var now = Date.now();
    if (now - window.wvt_lastTimeUpdate >= 2000) {
		wvt_notifyVideoPlaying();
        window.wvt_lastTimeUpdate = now;
    }
}

function wvt_reportVideoSize(video) {
	window.main.h5videoSizeCallback(video.videoWidth, video.videoHeight);
}

function wvt_setupVideo(video) {
	if (video.wvt_setup) {
		return;
	}
	if (document.fullscreenElement) {
		document.exitFullscreen();
	}

	wvt_enablePlayCheck();

	window.wvt_lastTimeUpdate = 0;

    if (!video.paused) {
    	wvt_log("Video is playing, enter fullscreen now.");
    	window.main.schemeEnterFullscreen();
    	wvt_reportVideoSize(video);
    	setTimeout(() => { wvt_ensureVideoVolume(video) }, 1000);
    }
    wvt_ensureVideoVolume(video);
    wvt_setupVideoListeners(video);
    video.autoplay = true;
    video.style['object-fit'] = 'fill';
    //video.controls = false;
    //video.removeAttribute('controls');
	video.wvt_setup = true;
	wvt_log("Video setup successfully")
}

function wvt_ensureVideoVolume(video) {
	video.muted = false;
	video.defaultMuted = false;
    video.volume = 1;
}

function wvt_setupVideoListeners(video) {
	video.addEventListener('play', function() {
    	wvt_log("Video state: PLAY.");
		window.main.schemeEnterFullscreen();
    	wvt_notifyVideoPlaying();
    	window.wvt_lastTimeUpdate = Date.now();
    	setTimeout(() => { wvt_ensureVideoVolume(video) }, 1000);
    });
    video.addEventListener('pause', function() {
    	wvt_log("Video state: PAUSE.");
    });
    video.addEventListener('timeupdate', function() {
        if (enablePlayCheck) { wvt_onTimeUpdate(video); }
    });
    video.addEventListener('error', function() {
    	wvt_log("Video state: ERROR: "+video.error.code);
    	window.main.h5videoErrorCallback(videoFromWebPage.error.code);
    });
    video.addEventListener('canplay', function(e) {
		wvt_log("Video state: CANPLAY.");
		wvt_reportVideoSize(video);
	});
    video.addEventListener('canplaythrough', function(e) {
    	wvt_log("Video state: CANPLAYTHROUGH.");
    });
//    video.addEventListener('durationchange', function(e) {
//    	console.log("Video state: DURATIONCHANGE.");
//    });
}

function wvt_setupNonVideo(element) {
    window.main.schemeEnterFullscreen();
}

function wvt_playVideo() {
    if (window.wvt_video != null && window.wvt_video.paused) {
        window.wvt_video.play();
    }
    if (window.wvt_video == null || window.wvt_video.paused) {
        if (needPreClick) {
            var element = wvt_getPreClickElement();
            if (element) {
            	element.click();
            }
        }
    }
}

function wvt_loop() {
    if(window.wvt_counter>=30){
        if(!window.wvt_video && !wvt_getVideoElement()){
            window.main.h5videoErrorCallback(5);
        }
        return
    }
	setTimeout(() => { wvt_loop() }, document.fullscreenElement ? 5000 : 1000);
	var counter = ++window.wvt_counter;

	if (window.wvt_video) {
		if (!document.documentElement.contains(window.wvt_video)) {
			wvt_error("Loop " + counter + ", video was removed.");
			window.main.disablePlayCheck();
			if (document.fullscreenElement) {
				document.exitFullscreen();
			}
			window.wvt_video = null;
		} else {
			if (window.wvt_video.paused) {
			    if (window.wvt_video.error == null) {
			        wvt_playVideo();
                    wvt_log("Loop " + counter + ", video paused, force play.");
			    } else {
			        wvt_log("Loop " + counter + ", video error, code = " + window.wvt_video.error.code + ".");
			    }
        	} else {

        	    try {
                    if(document.fullscreenElement == null){
                        window.main.schemeEnterFullscreen();
                        console.log('requestFullscreen to fullscreen');
                        isFullscreen = true;
                    }else{
                        wvt_log("Loop " + counter + ", already fullscreen nothing to do ");
                    }
                } catch (e) {
                    console.error("use video.requestFullscreen(), error [" + e + "]");
                }


        	    wvt_log("Loop " + counter + ", nothing to do.");
        	}
		}
	} else {
		var element = wvt_getVideoElement();
		if (element) {
			wvt_log("Loop " + counter + ", fullscreen tag = " + element.tagName + ".");
			window.wvt_video = element;
			if (element.tagName == 'VIDEO') {
			    wvt_setupVideo(element);
			} else {
			    wvt_setupNonVideo(element);
			}
		} else {
		    wvt_playVideo()
			wvt_error("Loop " + counter + ", fullscreen element not found.");
		}
	}
}

function wvt_makeVideoFullscreen() {
	if (document.fullscreenElement == null) {
		if (window.wvt_video && document.documentElement.contains(window.wvt_video)) {
		    var element = null;
		    try {
		        element = needEnterFullscreenButton ? wvt_getEnterFullscreenButton() : null;
		    } catch (e) {
		        wvt_error("use video.requestFullscreen(), element [" + enterFullscreenButton + "] not found.");
		    }
		    if (element != null) {
		        element.click();
		    } else {
		        window.wvt_video.requestFullscreen().catch((e) => {
                     wvt_error(e.message);
                });
		    }
		} else {
			wvt_error("wvt_video is null.");
		}
	} else {
		wvt_error("already in fullscreen.");
	}
}

function wvt_main() {
	document.onkeydown = function(e) {
		wvt_log('Key down: ' + e.key);
		if (e.key == 'f') { wvt_makeVideoFullscreen(); }
	}
	window.wvt_counter = 0;
	setTimeout(() => { wvt_loop() }, 1000);
}

function wvt_getVideoElement() {
    var nodes = document.all;
    for (var i = 0; i < nodes.length; i++){
    	var e = nodes[i];
    	if (e.tagName.toUpperCase() == 'VIDEO') {
    	    return e;
    	}
    }
    return null;
}

function wvt_getEnterFullscreenButton() {
    var nodes = document.all;
    for (var i = 0; i < nodes.length; i++){
    	var e = nodes[i];
    	if ($$enter_fullscreen_button_condition$$) {
    	    return e;
    	}
    }
    return null;
}

function wvt_getPreClickElement() {
    var nodes = document.all;
    for (var i = 0; i < nodes.length; i++){
    	var e = nodes[i];
    	if ($$pre_click_element_condition$$) {
    	    return e;
    	}
    }
    return null;
}

if (!window.wvt_javascriptInjected) {
	wvt_log("javascript injected successfully.");
	window.wvt_javascriptInjected = true;
	wvt_main();
} else {
	wvt_error("javascript already injected.");
}