# S3Upload Plugin for Typecho

S3 协议文件上传插件，支持自定义域名、CDN 等功能。

## 文件结构

1. **Plugin.php**
   - 插件主文件
   - 包含插件定义、配置和钩子
   - 负责插件的安装、激活和配置

2. **S3Client.php**
   - S3 协议客户端实现
   - 处理与 S3 服务器的通信
   - 实现文件上传、删除等基本操作

3. **StreamUploader.php**
   - 文件上传处理类
   - 处理文件分块上传
   - 管理上传过程和临时文件

4. **FileHandler.php**
   - 文件处理主类
   - 处理 Typecho 的文件上传钩子
   - 管理文件的上传、修改和删除

5. **Utils.php**
   - 工具类
   - 提供日志记录功能
   - 提供文件类型判断等辅助功能

## 功能特性

- 支持标准 S3 协议
- 支持自定义域名和 CDN
- 支持 HTTPS
- 支持文件本地备份
- 支持自定义存储路径
- 支持虚拟主机和路径两种访问方式

## 安装方法

1. 下载插件并解压到 `usr/plugins/S3Upload` 目录
2. 在 Typecho 后台启用插件
3. 配置 S3 相关参数

## 配置说明

- **Endpoint**: S3 服务器地址
- **Bucket**: 存储桶名称
- **Region**: 区域
- **Access Key**: 访问密钥 ID
- **Secret Key**: 访问密钥密码
- **自定义域名**: CDN 或自定义域名
- **HTTPS**: 是否使用 HTTPS
- **URL 风格**: 路径或虚拟主机方式
- **自定义路径**: 存储路径前缀
- **本地备份**: 是否保留本地副本

## 注意事项

1. 确保 PHP 已安装 curl 扩展
2. 确保目录有写入权限
3. 建议开启 PHP 错误日志
4. 建议定期检查日志文件

## 版本历史
- 1.1.0:
  - 上传本地备份路径不正确的问题 (现按照原始路径保存)

- 1.0.0: 初始版本
  - 基本的 S3 上传功能
  - 支持自定义域名
  - 支持 CDN 配置

## 作者

- @jkjoy

## 许可证

MIT License